<?php

defined( 'ABSPATH' ) || exit;

if( isset( $_POST['submit'] ) ) {
	$data = array(
		'aes_key' => $_POST['aes_key'],
		'user_id' => $_POST['user_id'],
		'device_id' => $_POST['device_id'],
		'device_name' => $_POST['device_name'],
		'note' => $_POST['note'],
		'disabled' => isset( $_POST['available'] ) ? '0' : '1'
	);
	global $wpdb;
	if( empty( $_POST['id'] ) ) {
		$wpdb->insert( "{$wpdb->prefix}saleadmin_keys", $data );
		wp_redirect( esc_url_raw( remove_query_arg( array( 'new' ) ) ) );
		exit;
	} else {
		$bind = W2WSA()->get_bind_by_id( $_POST['id'] );
		$wpdb->update( "{$wpdb->prefix}saleadmin_keys", $data, array( 'id' => $_POST['id'] ) );
		W2WSA()->remove_bind_cache( $bind['user_id'], $bind['device_id'] );
	}
	$saved = true;
}

$bind = W2WSA()->get_bind_by_id( $_REQUEST['id'] );
?>
<div class="wrap">
	<h1 class="wp-heading-inline">编辑绑定</h1>
	<?php if( $saved ): ?>
		<div class="notice notice-success"><p>保存成功</p></div>
	<?php endif; ?>
	<hr class="wp-header-end">
	<div id="poststuff">
		<div id="post-body" class="metabox-holder">
			<div id="post-body-content">
				<form method="post" action="">
				<table class="form-table">
				<tr><th><label for="aes_key">密钥</label></th><td>
				<input type="text" id="aes_key" name="aes_key" value="<?php echo isset( $bind['aes_key'] ) ? $bind['aes_key'] : '' ?>" class="regular-text" autocomplete="off">
				</td></tr>
				<tr><th><label for="user_id">用户ID</label></th><td>
				<input type="text" id="user_id" name="user_id" value="<?php echo isset( $bind['user_id'] ) ? $bind['user_id'] : '' ?>" class="regular-text" autocomplete="off">
				</td></tr>
				<tr><th><label for="device_id">设备ID</label></th><td>
				<input type="text" id="device_id" name="device_id" value="<?php echo isset( $bind['device_id'] ) ? $bind['device_id'] : '' ?>" class="regular-text" autocomplete="off">
				</td></tr>
				<tr><th><label for="device_name">设备名称</label></th><td>
				<input type="text" id="device_name" name="device_name" value="<?php echo isset( $bind['device_name'] ) ? $bind['device_name'] : '' ?>" class="regular-text" autocomplete="off">
				</td></tr>
				<tr><th><label for="note">备注</label></th><td>
				<input type="text" id="note" name="note" value="<?php echo isset( $bind['note'] ) ? $bind['note'] : '' ?>" class="regular-text" autocomplete="off">
				</td></tr>
				<tr><th><label for="available">可用</label></th><td>
				<label><input type="checkbox" id="available" name="available" <?php checked( $bind['disabled'] !== '1' ) ?>></label>
				</td></tr>
				</table>
				<input type="hidden" name="id" value="<?php echo isset( $bind['id'] ) ? $bind['id'] : '' ?>" />
				<p class="submit"><input type="submit" name="submit" id="submit" class="button button-primary" value="保存"></p>
				</form>
			</div>
		</div>
		<br class="clear">
	</div>
</div>