<?php
/**
 * Plugin Name: SaleAdmin - WooCommerce店铺管理小程序
 * Plugin URI: https://manage.woocommerce-app.com/
 * Description: 商家可通过小程序端管理店铺，进行商品编辑发布，订单查看、改价、发货、退款、备注，店铺数据查看等操作
 * Version: 1.2
 * Author: 米点网络科技
 * Author URI: https://www.miidim.com/
 * WC requires at least: 4.0.0
 * WC tested up to: 6.3.1
**/

defined( 'ABSPATH' ) || exit;

define( 'WP_W2W_Store_Admin_PATH', plugin_dir_path( __FILE__ ) );
define( 'WP_W2W_Store_Admin_URL', plugin_dir_url( __FILE__ ) );
define( 'WP_W2W_Store_Admin_QRCode_URL', 'https://manage.woocommerce-app.com/wp-admin/admin-ajax.php' );

include_once( WP_W2W_Store_Admin_PATH . 'includes/class-w2w-store-admin.php' );

add_action( 'admin_init', function() {
	if( class_exists( 'Puc_v4_Factory' ) ) {
		Puc_v4_Factory::buildUpdateChecker(
			'https://manage.woocommerce-app.com/wc-api/product/saleadmin',
			__FILE__,
			'saleadmin'
		);
	}
} );

function W2WSA() {
	return W2W_Store_Admin::instance();
}

$GLOBALS['w2wsa'] = W2WSA();